# Firma anlegen

Jede Firma muss einer Kontaktliste zugeordnet werden und kann bei Bedarf mehrere Kontakte enthalten, die bspw. in der Firma arbeiten.

Um eine neue Firma anzulegen, muss die Aktion <span
style='font-weight:bold;font-style:italic'>Neue Firma</span> aufgerufen werden. Diese steht als Schaltfläche in der Multifunktionsleiste oder als Kachel zur Verfügung.

## Aktion: Neue Firma

Die Aktion kann im Registertab <span
style='font-weight:bold;font-style:italic'>Kontakte </span>der Multifunktionsleiste aufgerufen werden. 

{@img img1.png}

Ab ELO 10 wird zusätzlich die Kachel <span
style='font-weight:bold;font-style:italic'>Neue Firma</span><span
style='font-weight:bold'> </span>angeboten.

### Vorbedingung

*   Ein<span
style='font-weight:bold'> Firmentyp</span> ist ausgewählt (nur falls mehrere Typen vorhanden).

### Dateneingabe

Für die Dateneingabe wird die Formular-Tab-Gruppe <span
style='font-weight:bold;font-style:italic'>002_create_company</span> eingesetzt. 

{@img img3.png}

Diese setzt sich aus folgenden Bausteinen zusammen:

<table><thead><tr><td><span
style='font-weight:bold'>Firma</span></td></tr></thead><tbody><tr><td>100_company_target</td></tr><tr><td>111_company_name</td></tr><tr><td>120_company_communication</td></tr><tr><td>130_company_address</td></tr></tbody></table>

### Implementierung

<span class="tag_warning"><span
style='font-weight:bold'>Action definitions:</span> Definitionen der Aktion für die Clients finden sich in der Konfiguration <span
style='font-weight:bold;font-style:italic'>sol.contact.ix.actions.CreateCompany</span>.</span>

Der <span
style='font-weight:bold'>technische Ablauf</span> wird durch die Indexserver-Aktion <span
style='font-weight:bold;font-style:italic'>sol.contact.ix.actions.CreateCompany</span> implementiert. Diese klont ein neues Element auf Basis des ausgewählten Firmentyps in der Chaosablage und startet den Workflow <span
style='font-weight:bold;font-style:italic'>sol.contact.company.create</span>.

Im Erfolgsfall werden folgende Events an den Client übermittelt:

<table><thead><tr><td><span
style='font-weight:bold'>Event</span></td><td><span
style='font-weight:bold'>Beschreibung</span></td><td><span
style='font-weight:bold'>Status</span></td></tr></thead><tbody><tr><td>DIALOG</td><td>Zeigt das Formular zur Dateneingabe in einem Dialog an</td><td></td></tr><tr><td>GOTO</td><td>Zeigt das neu angelegte Element im Client an</td><td>CREATE</td></tr></tbody></table>

<span
style='font-weight:bold'>Beschreibung des Workflows</span>

{@img img5.png}

<table><thead><tr><td><span
style='font-weight:bold'>Knotenbezeichnung</span></td><td><span
style='font-weight:bold'>Knotenname deutsch und Beschreibung</span></td><td><span
style='font-weight:bold'>Funktion</span></td></tr></thead><tbody><tr><td><span
style='font-weight:bold'>PRE-FILL: contactlist</span></td><td><span
style='font-weight:bold'>PRE-FILL: Kontaktliste</span><br />Verteilungsknoten: Automatische Vorbefüllung von Kontaktdaten</td><td>sol.common.ix.functions.ApplyDynKwl</td></tr><tr><td><span
style='font-weight:bold'>Create company</span></td><td><span
style='font-weight:bold'>Firma anlegen</span><br />Benutzerknoten: Anlegen einer neuen Firma durch den Eigentümer</td><td></td></tr><tr><td><span
style='font-weight:bold'>MOVE: company</span></td><td><span
style='font-weight:bold'>MOVE: Firma</span><br />Verteilungsknoten: Verschiebt das SORD in ein anderes Verzeichnis</td><td>sol.common.ix.functions.Move</td></tr><tr><td><span
style='font-weight:bold'>GENERATOR: company reference</span></td><td><span
style='font-weight:bold'>GENERATOR: Firmennummer</span><br />Verteilungsknoten: Erzeugt eine interne Firmennummer</td><td>sol.contact.ix.functions.generators.GenerateCompanyReference</td></tr><tr><td><span
style='font-weight:bold'>GENERATE SHORTDESC: company</span></td><td><span
style='font-weight:bold'>GENERATE SHORTDESC: Firma</span><br />Verteilungsknoten: Passt die Kurzbezeichnung der Firma an</td><td>sol.contact.ix.functions.generators.GenerateCompanyName</td></tr><tr><td><span
style='font-weight:bold'>GENERATE REGISTERTAB: company</span></td><td><span
style='font-weight:bold'>GENERATE REGISTERTAB: Firma</span><br />Verteilungsknoten: Legt eine Ablagestruktur für die Firma an</td><td>sol.contact.ix.functions.generators.GenerateCompanyFilingStruct</td></tr><tr><td><span
style='font-weight:bold'>DELETE: temporary company</span></td><td><span
style='font-weight:bold'>DELETE: Temporäre Firma</span><br />Verteilungsknoten: Löscht das SORD-Objekt aus der Chaosablage</td><td>sol.common.ix.functions.Delete</td></tr></tbody></table>
